<?php

namespace Discovereel\Objects;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Object extends Model 
{

    protected $table = 'object';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function objectType()
    {
        return $this->belongsTo('ObjectType');
    }

    public function reel()
    {
        return $this->belongsTo('Reel');
    }

    public function lists()
    {
        return $this->belongsToMany('List');
    }

}